﻿import { StarXpandCommand } from "star-io10-web";

export class LabelSample13_For203dpi_Sale50PercentOff_Template {
  static async createTemplate(): Promise<string> {
    let builder = new StarXpandCommand.StarXpandCommandBuilder();

    builder.addDocument(
      new StarXpandCommand.DocumentBuilder()
        .settingPrintableArea(72.0)
        .addPrinter(
          new StarXpandCommand.PrinterBuilder()
            .styleAlignment(StarXpandCommand.Printer.Alignment.Center)
            .addPageMode(
              new StarXpandCommand.Printer.PageModeAreaParameter(72.0, 68.0),
              new StarXpandCommand.PageModeBuilder()
                .actionPrintImage(
                  new StarXpandCommand.Printer.PageModeImageParameter(
                    "sale_50off_background.png",
                    0.0,
                    0.0,
                    590,
                  ),
                )
                .styleHorizontalPositionTo(7.0)
                .styleMagnification(
                  new StarXpandCommand.MagnificationParameter(4, 4),
                )
                .styleVerticalPositionTo(42.0)
                .actionPrintText(
                  "${note}\n",
                  new StarXpandCommand.Printer.TextParameter().setWidth(
                    10,
                    new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                      StarXpandCommand.Printer.TextAlignment.Center,
                    ),
                  ),
                ),
            )
            .actionCut(StarXpandCommand.Printer.CutType.Partial),
        ),
    );
    return await builder.getCommands();
  }

  static async getFieldData(): Promise<string> {
    return Promise.resolve(
      `{
    "note" : "50%  OFF"
}`,
    );
  }
}
